//
//  LogoViewController.m
//  Logo
//
//  Created by Jonathan Diehl on 02.03.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "LogoViewController.h"

@implementation LogoViewController

@synthesize imageView;


// init
- (void)viewDidLoad {

	// run loader
	NSURL *url = [NSURL URLWithString:@"http://hci.rwth-aachen.de/img/wiki_up/i10Logo_rgba_small.png"];
	NSURLRequest *request = [NSURLRequest requestWithURL:url];
	loader = [[URLLoader alloc] initWithRequest:request];
	loader.delegate = self;
	[loader start];
}


#pragma mark URLLoaderDelegate

- (void)urlLoader:(URLLoader *)aLoader didFinishLoadingData:(NSData *)data;
{
	// create an image form the data
	UIImage *image = [UIImage imageWithData:data];
	
	// display the image
	self.imageView.image = image;
	
	[loader release];
	loader = nil;
}


#pragma mark Memory management

// cleanup
- (void) dealloc
{
	[loader release];
	[super dealloc];
}


@end
